'use strict';

var main_control = function () {
	this.connected_to = false;
	this.operating_system;

	// check which operating system is user running
	if (navigator.appVersion.indexOf("Win") != -1) this.operating_system = "Windows";
	else if (navigator.appVersion.indexOf("Mac") != -1) this.operating_system = "MacOS";
	else if (navigator.appVersion.indexOf("CrOS") != -1) this.operating_system = "ChromeOS";
	else if (navigator.appVersion.indexOf("Linux") != -1) this.operating_system = "Linux";
	else if (navigator.appVersion.indexOf("X11") != -1) this.operating_system = "UNIX";
	else this.operating_system = "Unknown";
};

main_control.prototype.log = function (message) {
	var logView = $('div#logView');
	var d = new Date();
	var year = d.getFullYear();
	var month = ((d.getMonth() < 9) ? '0' + (d.getMonth() + 1) : (d.getMonth() + 1));
	var date = ((d.getDate() < 10) ? '0' + d.getDate() : d.getDate());
	var time = ((d.getHours() < 10) ? '0' + d.getHours() : d.getHours()) + ':' + ((d.getMinutes() < 10) ? '0' + d.getMinutes() : d.getMinutes()) + ':' + ((d.getSeconds() < 10) ? '0' + d.getSeconds() : d.getSeconds());

	var formattedDate = "[{0}/{1}/{2} - {3}]".format(year, month, date, time);
	$('div.logOutput', logView).append('<p>' + formattedDate + ' ' + message + '</p>');
	logView.scrollTop($('div.logOutput', logView).height());
};

main_control.prototype.content_ready = function (callback) {
	$('.togglesmall').each(function (index, html) {
		var switchery = new Switchery(html, {
			size: 'small',
			color: '#59aa29',
			secondaryColor: '#c4c4c4'
		});

		$(html).removeClass('togglesmall');
	});

	$('.toggle').each(function (index, html) {
		var switchery = new Switchery(html, {
			color: '#59aa29',
			secondaryColor: '#c4c4c4'
		});

		$(html).removeClass('toggle');
	});

	if (callback) callback();
}

// initialize object into GUI variable
var MAIN = new main_control();