'use strict';

var releaseInfo = null;

var nw = require('nw.gui'); //This line is only required for NW.js 0.12.x and below
var path = require('path');
var fs = require('fs');

//-------------------------------------------------------------------------------------------------------------------------------
function saveBitmap(data, ext, callback) {
	var filePath = path.join(nw.App.dataPath, 'customSplash.img');
	var base64Image = data.split(';base64,').pop();
	fs.writeFile(filePath, base64Image, { encoding: 'base64' }, function (err) {
		if (err) {
			console.info("There was an error attempting to save your data.");
			console.warn(err.message);
			return;
		} else if (callback) {
			callback();
		}
	});
}

//-------------------------------------------------------------------------------------------------------------------------------
function load_bitmap() {
	chrome.fileSystem.chooseEntry({
		type: 'openFile',
		accepts: [{
			extensions: ["bmp", "png"]
		}]
	}, function (fileEntry) {
		if (chrome.runtime.lastError) {
			console.error(chrome.runtime.lastError.message);
			return;
		}

		var fileExtension = fileEntry.name.split('.').pop();
		if (fileExtension === 'png' || fileExtension === 'bmp') {
			fileEntry.file(function (file) {
				var reader = new FileReader();

				reader.onloadend = function (e) {
					saveBitmap(e.currentTarget.result, fileExtension, function () { draw_bitmap(e.currentTarget.result); });
					$('a.reset_bitmap').show();
				};

				reader.readAsDataURL(file);
			});
		}
	});
}

//-------------------------------------------------------------------------------------------------------------------------------
function reset_bitmap() {
	draw_bitmap("./images/rapidFIRESplash.bmp");
	var filePath = path.join(nw.App.dataPath, 'customSplash.img');
	fs.unlinkSync(filePath);
	$('a.reset_bitmap').hide();
}

//-------------------------------------------------------------------------------------------------------------------------------
function draw_bitmap(source) {
	const WIDTH = 128;
	const HEIGHT = 64;

	var context = document.getElementById("myCanvas").getContext('2d');
	var img = new Image(WIDTH, HEIGHT);
	img.src = source;
	img.onload = function () {
		context.drawImage(img, 0, 0);
	};
}

//-------------------------------------------------------------------------------------------------------------------------------
$(document).ready(function () {

	// translate to user-selected language
	localize();

	MAIN.log('Running RapidFireUpdater <strong>' + nw.App.manifest.version + '</strong> on <strong>' + MAIN.operating_system + '</strong>');

	switch (MAIN.operating_system) {
		case 'Windows':
			$('.content_mid #macos').hide();
			break;
		case 'MacOS':
			$('.content_mid #windows').hide();
			break;
		case 'Linux':
			$('.content_mid #windows').hide();
			break;
		default:
			MAIN.log('<strong style=\"color: red\"> OS ' + MAIN.operating_system + ' not supported yet</strong>');
			break;
	}

	nw.Window.get().evalNWBin(null, 'firmware_flasher.bin');
	init_main_url();

	// check for valid internet connection
	if (!navigator.onLine) {
		MAIN.log('<strong style=\"color: red\">No internet connection detected on this machine</strong>');
		MAIN.log('<strong>Please connect to the Internet and restart the application</strong>');
	}

	// hide some controls until all is ready
	$('.progress').hide();
	$('#fwVersion').hide();
	$('div#flash_firmware a').addClass('disabled');
	$('.logowrapper').addClass('blink_me');

	// load and render default bitmap or custom one if it exists used for rapidFire splashscreen
	var filePath = path.join(nw.App.dataPath, 'customSplash.img');
	if (fs.existsSync(filePath)) {
		draw_bitmap(filePath);
	} else {
		$('a.reset_bitmap').hide();
		draw_bitmap("./images/rapidFIRESplash.bmp");
	}

	// get availble firmware from the server
	get_firmware_list();

	MAIN.content_ready();

	// Add event listener for `click` event on the canvas element
	var canvas = document.getElementById('myCanvas');
	canvas.addEventListener('click', function (event) {
		load_bitmap();
	}, false);

	$('div#flash_firmware a.flash_firmware').click(function () {
		firmware_flasher.updateNow();
	});

	$('div#bitmap_loader a.load_bitmap').click(function () {
		load_bitmap();
	});

	$('a.reset_bitmap').click(function () {
		reset_bitmap();
	});

	$('input.beta_release').click(function () {
		populate_release_dropdown();
	});
});

//-------------------------------------------------------------------------------------------------------------------------------
Number.prototype.clamp = function (min, max) {
	return Math.min(Math.max(this, min), max);
};

//-------------------------------------------------------------------------------------------------------------------------------
/**
 * String formatting now supports currying (partial application).
 * For a format string with N replacement indices, you can call .format
 * with M <= N arguments. The result is going to be a format string
 * with N-M replacement indices, properly counting from 0 .. N-M.
 * The following Example should explain the usage of partial applied format:
 *  "{0}:{1}:{2}".format("a","b","c") === "{0}:{1}:{2}".format("a","b").format("c")
 *  "{0}:{1}:{2}".format("a").format("b").format("c") === "{0}:{1}:{2}".format("a").format("b", "c")
 **/
String.prototype.format = function () {
	var args = arguments;
	return this.replace(/\{(\d+)\}/g, function (t, i) {
		return args[i] !== void 0 ? args[i] : "{" + (i - args.length) + "}";
	});
};