'use strict';

var PortHandler = new function () {
	this.initial_ports = false;
	this.port_detected_callbacks = [];
	this.port_removed_callbacks = [];
	this.dfu_available = false;
};

PortHandler.initialize = function () {
	// start listening, check after 250ms
	this.check();
};

PortHandler.check = function () {
	var self = this;

	serial.getDevices(function (current_ports) {
		// port got removed or initial_ports wasn't initialized yet
		if (self.array_difference(self.initial_ports, current_ports).length > 0 || !self.initial_ports) {
			var removed_ports = self.array_difference(self.initial_ports, current_ports);

			if (self.initial_ports != false) {
				if (removed_ports.length > 1) {
					console.log('PortHandler - Removed: ' + removed_ports);
				} else {
					console.log('PortHandler - Removed: ' + removed_ports[0]);
				}
			}

			self.update_port_select(current_ports);

			// trigger callbacks (only after initialization)
			if (self.initial_ports) {
				for (var i = (self.port_removed_callbacks.length - 1); i >= 0; i--) {
					var obj = self.port_removed_callbacks[i];

					// remove timeout
					clearTimeout(obj.timer);

					// trigger callback
					obj.code(removed_ports);

					// remove object from array
					var index = self.port_removed_callbacks.indexOf(obj);
					if (index > -1) self.port_removed_callbacks.splice(index, 1);
				}
			}

			if (!self.initial_ports) {
				// initialize
				self.initial_ports = current_ports;
			} else {
				for (var i = 0; i < removed_ports.length; i++) {
					self.initial_ports.splice(self.initial_ports.indexOf(removed_ports[i]), 1);
				}
			}
		}

		// new port detected
		var new_ports = self.array_difference(current_ports, self.initial_ports);

		if (new_ports.length) {
			if (new_ports.length > 1) {
				console.log('PortHandler - Found: ' + new_ports);
			} else {
				console.log('PortHandler - Found: ' + new_ports[0]);
			}

			self.update_port_select(current_ports);

			// select / highlight new port, if connected -> select connected port
			if (!MAIN.connected_to) {
				$('div#top-bar #port').val(new_ports[0]);
			} else {
				$('div#top-bar #port').val(MAIN.connected_to);
			}

			// trigger callbacks
			for (var i = (self.port_detected_callbacks.length - 1); i >= 0; i--) {
				var obj = self.port_detected_callbacks[i];

				// remove timeout
				clearTimeout(obj.timer);

				// trigger callback
				obj.code(new_ports);

				// remove object from array
				var index = self.port_detected_callbacks.indexOf(obj);
				if (index > -1) self.port_detected_callbacks.splice(index, 1);
			}

			self.initial_ports = current_ports;
		}

		if (self.initial_ports.length == 0) {
			$('#comStatus').removeClass('led-green').addClass('led-red');
			$('div#flash_firmware a').addClass('disabled');
		}

		//self.check_usb_devices();

		MAIN.updateManualPortVisibility();
		setTimeout(function () {
			self.check();
		}, 250);
	});
};

PortHandler.update_port_select = function (ports) {
	$('div#top-bar #port').html(''); // drop previous one

	for (var i = 0; i < ports.length; i++) {
		$('div#top-bar #port').append($("<option/>", { value: ports[i], text: ports[i], data: { isManual: false } }));
	}

	$('div#top-bar #port').append($("<option/>", { value: 'manual', text: 'Manual Selection', data: { isManual: true } }));
};

PortHandler.port_detected = function (name, code, timeout, ignore_timeout) {
	var self = this;
	var obj = { 'name': name, 'code': code, 'timeout': (timeout) ? timeout : 10000 };

	if (!ignore_timeout) {
		obj.timer = setTimeout(function () {
			console.log('PortHandler - timeout - ' + obj.name);

			// trigger callback
			code(false);

			// remove object from array
			var index = self.port_detected_callbacks.indexOf(obj);
			if (index > -1) self.port_detected_callbacks.splice(index, 1);
		}, (timeout) ? timeout : 10000);
	} else {
		obj.timer = false;
		obj.timeout = false;
	}

	this.port_detected_callbacks.push(obj);

	return obj;
};

PortHandler.port_removed = function (name, code, timeout, ignore_timeout) {
	var self = this;
	var obj = { 'name': name, 'code': code, 'timeout': (timeout) ? timeout : 10000 };

	if (!ignore_timeout) {
		obj.timer = setTimeout(function () {
			console.log('PortHandler - timeout - ' + obj.name);

			// trigger callback
			code(false);

			// remove object from array
			var index = self.port_removed_callbacks.indexOf(obj);
			if (index > -1) self.port_removed_callbacks.splice(index, 1);
		}, (timeout) ? timeout : 10000);
	} else {
		obj.timer = false;
		obj.timeout = false;
	}

	this.port_removed_callbacks.push(obj);

	return obj;
};

// accepting single level array with "value" as key
PortHandler.array_difference = function (firstArray, secondArray) {
	var cloneArray = [];

	// create hardcopy
	for (var i = 0; i < firstArray.length; i++) {
		cloneArray.push(firstArray[i]);
	}

	for (var i = 0; i < secondArray.length; i++) {
		if (cloneArray.indexOf(secondArray[i]) != -1) {
			cloneArray.splice(cloneArray.indexOf(secondArray[i]), 1);
		}
	}

	return cloneArray;
};

PortHandler.flush_callbacks = function () {
	var killed = 0;

	for (var i = this.port_detected_callbacks.length - 1; i >= 0; i--) {
		if (this.port_detected_callbacks[i].timer) clearTimeout(this.port_detected_callbacks[i].timer);
		this.port_detected_callbacks.splice(i, 1);

		killed++;
	}

	for (var i = this.port_removed_callbacks.length - 1; i >= 0; i--) {
		if (this.port_removed_callbacks[i].timer) clearTimeout(this.port_removed_callbacks[i].timer);
		this.port_removed_callbacks.splice(i, 1);

		killed++;
	}

	return killed;
};