'use strict';

//-------------------------------------------------------------------------------------------------------------------------------
function populate_release_dropdown() {
	var firmware_dropdown = $('select#firmware.dropdown-select');
	firmware_dropdown.empty(); // empty previous values

	releaseInfo.filter(
		function (releaseInfo) {
			if (releaseInfo.product == "GoggleBrain") {
				var version = releaseInfo.versions;
				var verIdx = 0;
				var optIdx = 0;
				for (verIdx = 0; verIdx < version.length; verIdx++) {
					if (!version[verIdx].prerelease || ($('input.beta_release').is(':checked')))
						firmware_dropdown.append(new Option(version[verIdx].tag_name, optIdx++));
				}

				// select the last one which should be the most recent one.
				firmware_dropdown.val(optIdx - 1);

				// control is ready so we can show it now
				$('#fwVersion').show();
			}
		}
	);
}

//-------------------------------------------------------------------------------------------------------------------------------
function get_firmware_list(callback) {
	var url_address = server_url + '/' + get_branch_name(false) + '/release';
	console.debug('url_address: ' + url_address);

	var oReq = new XMLHttpRequest();
	oReq.open("GET", url_address, true);
	oReq.responseType = "json";

	oReq.onload = function (oEvent) {
		if (oReq.status == 200) {
			releaseInfo = oReq.response; // Note: not oReq.responseText
			populate_release_dropdown();
			if (callback)
				callback();
		}
	};

	oReq.onerror = function (oEvent) {
		connection_error('Get Data from Server failed, please retry');
		console.error("server error");
	};

	oReq.send(null);
}

//-------------------------------------------------------------------------------------------------------------------------------
function getVersionInfo(tag) {
	var prodInfo = releaseInfo.filter(function (releaseInfo) {
		return releaseInfo.product == "GoggleBrain";
	});
	if (prodInfo.length == 1) {
		var version = prodInfo[0].versions;
		return version.filter(function (versionInfo) {
			return versionInfo.tag_name == tag;
		});
	}
}

//-------------------------------------------------------------------------------------------------------------------------------
function get_firmware_version(rfFw) {
	var selected_version = $('select[id="firmware"] :selected').text();
	var found = getVersionInfo(selected_version);
	if (found.length == 1) {
		if (rfFw) {
			return found[0].rf_firmware;
		} else {
			return found[0].gb_firmware;
		}
	}
}

////-------------------------------------------------------------------------------------------------------------------------------
//function getLastAppVersionInfo(os) {
//	var prodInfo = releaseInfo.filter(function (releaseInfo) {
//		return releaseInfo.product == "RapidFireUpdater";
//	});
//	if (prodInfo.length == 1) {
//		var version = prodInfo[0].versions;

//		var res = version.filter(function (versionInfo) {
//			return versionInfo.os === os;
//		});

//		if (res.length === 1) {
//			return res[0].tag_name;
//		}
//	}
//}

//-------------------------------------------------------------------------------------------------------------------------------
function getLastAppVersionInfo(os) {
	var prodInfo = releaseInfo.filter(function (releaseInfo) {
		return releaseInfo.product == "RapidFireUpdater";
	});
	if (prodInfo.length == 1) {
		var version = prodInfo[0].versions;

		var res = version.filter(function (versionInfo) {
			return versionInfo.os === os;
		});

		if (res.length === 1) {
			return res[0];
		}
	}
}

