'use strict';

//-------------------------------------------------------------------------------------------------------------------------------
$(document).ready(function () {
	MAIN.updateManualPortVisibility = function () {
		var selected_port = $('div#top-bar #port option:selected');
		if (selected_port.data().isManual) {
			$('#port-override-option').show();
		} else {
			$('#port-override-option').hide();
		}
	};

	MAIN.updateManualPortVisibility();

	$('#port-override').change(function () {
		chrome.storage.local.set({
			'portOverride': $('#port-override').val()
		});
	});

	chrome.storage.local.get('portOverride', function (data) {
		$('#port-override').val(data.portOverride);
	});

	$('div#top-bar #port').change(function (target) {
		MAIN.updateManualPortVisibility();
	});

	PortHandler.initialize();
	PortUsage.initialize();
});

function onClosed(result) {
	if (result) { // All went as expected
		MAIN.log(chrome.i18n.getMessage('serialPortClosedOk'));
	} else { // Something went wrong
		MAIN.log(chrome.i18n.getMessage('serialPortClosedFail'));
	}

	$('#firmware_flasher').show();
}

function read_serial(info) {
}